package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.entity.EntityModifiable;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.entity.CCEntityAnything;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAITaskEntry;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;

public class GenePassive extends Gene{

	public GenePassive(int id) {
		super(id);
	}

	@Override
	public String getName() {
		return "Passive";
	}

	@Override
	public int getMaxAmount() {
		return 1;
	}

	@Override
	public String getStringValue(int amount) {
		return "Passive";
	}

	@Override
	public int getColour() {
		return 0xff33dd22;
	}

	@Override
	public Class[] getEntityClassesWithGene() {
		return new Class[]{EntityCow.class, EntityMooshroom.class, EntityChicken.class, EntityPig.class, EntitySquid.class,
				EntityBat.class, EntityHorse.class, EntityOcelot.class, EntitySheep.class, EntityVillager.class};
	}
	
	Class[] aiTaskRemove = new Class[]{EntityAIBreakDoor.class, EntityAIAttackOnCollide.class, EntityAIArrowAttack.class,
			EntityAICreeperSwell.class, EntityAIHurtByTarget.class, EntityAILeapAtTarget.class};

	@Override
	public void onUpdate(EntityLivingBase entity, IModifiable mod, int level) {
		if(entity instanceof EntityLiving){
			EntityLiving affect = (EntityLiving)entity;
			if(entity instanceof CCEntityAnything){
				affect = (EntityLiving)((CCEntityAnything)entity).theEntity;
			}
			if(affect != null){
				List<EntityAITaskEntry> tasks = (List<EntityAITaskEntry>)affect.tasks.taskEntries;
				if(tasks.size() > 0){
					ArrayList<EntityAIBase> remove = new ArrayList<EntityAIBase>();
					for(int a = 0; a < tasks.size(); a++){
						EntityAITaskEntry entry = tasks.get(a);
						for(int b = 0; b < aiTaskRemove.length; b++){
							if(aiTaskRemove[b].equals(entry.action.getClass())){
								remove.add(entry.action);
							}
						}
					}
					for(int a = remove.size()-1; a >= 0; a--){
						affect.tasks.removeTask(remove.get(a));
					}
				}

			}
		}
		
		/*if(entity instanceof CCEntityAnything){
			CCEntityAnything entity2 = (CCEntityAnything)entity;
			if(entity2.theEntity != null && entity2.theEntity instanceof EntityLiving){
				EntityLiving entityLiving = (EntityLiving)entity2.theEntity;
				List<EntityAITaskEntry> tasks = (List<EntityAITaskEntry>)entityLiving.tasks.taskEntries;
				if(tasks.size() > 0){
					ArrayList<EntityAIBase> remove = new ArrayList<EntityAIBase>();
					for(int a = 0; a < tasks.size(); a++){
						EntityAITaskEntry entry = tasks.get(a);
						for(int b = 0; b < aiTaskRemove.length; b++){
							if(aiTaskRemove[b].equals(entry.action.getClass())){
								remove.add(entry.action);
							}
						}
					}
					for(int a = remove.size()-1; a >= 0; a--){
						entityLiving.tasks.removeTask(remove.get(a));
					}
				}
			}
		}*/
	}

	@Override
	public void addGeneEffect(EntityLivingBase entity, int level) {
	}

}
